/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.VWConfiguration;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VWTrace {
    public static final int BASIC = 1;
    public static final int OBJECT = 2;
    public static final int COM_FUNC = 4;
    public static final int PARAM = 8;
    public static final int STEP = 16;
    public static final int TIMER = 256;
    public static final int COMREF = 2048;
    public static final int ALWAYS = Integer.MAX_VALUE;
    private boolean logEnabled = false;
    private int debugLevel = 0;
    private String debugFile = "eProcess.txt";
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    protected static VWTrace gVWTrace = new VWTrace();

    public static String _get_FILE_DATE() {
        return "$Date:   25 Jan 2005 08:54:18  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dmcphee  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    protected VWTrace() {
        try {
            VWConfiguration config = new VWConfiguration("eProcess");
            this.debugLevel = Integer.parseInt(config.getItemValue("debugLevel", null));
            this.debugFile = config.getItemValue("debugFile", null);
            this.logEnabled = this.debugLevel > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _println(int logLevel, String text) {
        if (!this.logEnabled) {
            return;
        }
        PrintStream outFile = null;
        try {
            String outText = dateFormatter.format(new Date()) + " " + text;
            outFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.debugFile, true)));
            if (logLevel == Integer.MAX_VALUE) {
                outFile.println(outText);
            } else if ((logLevel & this.debugLevel) > 0) {
                outFile.println(outText);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
            outFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _printStackTrace(String locationDesc, Exception ex) {
        PrintStream outFile = null;
        try {
            outFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.debugFile, true)));
            outFile.println(dateFormatter.format(new Date()) + " EXCEPTION! at " + locationDesc);
            ex.printStackTrace(outFile);
        }
        catch (Exception e) {
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
            outFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _printStackTrace(Exception ex) {
        PrintStream outFile = null;
        try {
            outFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.debugFile, true)));
            outFile.println(dateFormatter.format(new Date()) + " VWIDMSvc caught EXCEPTION!");
            ex.printStackTrace(outFile);
        }
        catch (Exception exception) {
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
            outFile = null;
        }
    }

    public static synchronized void println(String text) {
        gVWTrace._println(1, text);
    }

    public static synchronized void println(int logLevel, String text) {
        gVWTrace._println(logLevel, text);
    }

    public static synchronized void printStackTrace(String locationDesc, Exception ex) {
        gVWTrace._printStackTrace(locationDesc, ex);
    }

    public static synchronized void printStackTrace(Exception ex) {
        gVWTrace._printStackTrace(ex);
    }
}

